------------------==≡≡[ CREATING AND APPLYING SAVED VARIABLES ]≡≡==------------------

BFAUI_SavedVars = {}

local options = {
    PixelPerfect = false,
    HideGryphons = false,
    KeybindVisibility = {
        PrimaryBar = true,
        BottomLeftBar = true,
        BottomRightBar = true,
        RightBar = true,
        RightBar2 = true
    }
}

print("Battle for Azeroth UI: |cffdedee2Type /bfa to toggle the options menu.")
local checked
local function EnteringWorld()
    checked = nil
    if next(BFAUI_SavedVars) == nil then
        BFAUI_SavedVars = {}
        BFAUI_SavedVars.Options = options

        if BFAUI_SavedVars.Options.XPBarText == nil then
            BFAUI_SavedVars.Options.XPBarText = (GetCVar("xpBarText") == "1")
        end
        StaticPopup_Show("BFAUI_WELCOME")
    else -- Apply Saved Variables:
        if BFAUI_SavedVars.Options.KeybindVisibility.PrimaryBar then
            PrimaryBarAlpha = 1
        else
            PrimaryBarAlpha = 0
        end

        if BFAUI_SavedVars.Options.KeybindVisibility.BottomLeftBar then
            BottomLeftBarAlpha = 1
        else
            BottomLeftBarAlpha = 0
        end

        if BFAUI_SavedVars.Options.KeybindVisibility.BottomRightBar then
            BottomLeftBarAlpha = 1
        else
            BottomLeftBarAlpha = 0
        end

        if BFAUI_SavedVars.Options.KeybindVisibility.RightBar then
            RightBarAlpha = 1
        else
            RightBarAlpha = 0
        end

        if BFAUI_SavedVars.Options.KeybindVisibility.RightBar2 then
            RightBar2Alpha = 1
        else
            RightBar2Alpha = 0
        end

        for i = 1, 12 do
            _G["ActionButton" .. i .. "HotKey"]:SetAlpha(PrimaryBarAlpha)
            _G["MultiBarBottomLeftButton" .. i .. "HotKey"]:SetAlpha(BottomLeftBarAlpha)
            _G["MultiBarBottomRightButton" .. i .. "HotKey"]:SetAlpha(BottomLeftBarAlpha)
            _G["MultiBarRightButton" .. i .. "HotKey"]:SetAlpha(RightBarAlpha)
            _G["MultiBarLeftButton" .. i .. "HotKey"]:SetAlpha(RightBar2Alpha)
        end
    end
end

local f = CreateFrame("Frame")
f:RegisterEvent("ADDON_LOADED")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:SetScript("OnEvent", EnteringWorld)

------------------------------==≡≡[ OPTIONS FRAME ]≡≡==------------------------------

SlashCmdList.BFA = function()
    if BFAOptionsFrame:IsShown() then
        BFAOptionsFrame:Hide()
        PlaySound(89) -- GAMEDIALOGCLOSE
    else
        BFAOptionsFrame:Show()
        PlaySound(88) -- GAMEDIALOGOPEN
    end
end
SLASH_BFA1 = "/bfa"
SLASH_BFA2 = "/bfaui"

local function PixelPerfect()
    if BFAUI_SavedVars.Options.PixelPerfect == true then
        -- enable system button, hide text
        Advanced_UseUIScale:Disable()
        Advanced_UIScaleSlider:Disable()
        getglobal(Advanced_UseUIScale:GetName() .. "Text"):SetTextColor(1, 0, 0, 1)
        getglobal(Advanced_UseUIScale:GetName() .. "Text"):SetText(
            "The 'Use UI Scale' toggle is unavailable while Pixel Perfect mode is active. Type '/bfa' for options."
        )
        Advanced_UseUIScaleText:SetPoint("LEFT", Advanced_UseUIScale, "LEFT", 4, -40)
    end
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:SetScript("OnEvent", PixelPerfect)

local function HideGryphons()
    if BFAUI_SavedVars.Options.HideGryphons == true then
        MainMenuBarLeftEndCap:Hide()
        MainMenuBarRightEndCap:Hide()
    end
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:SetScript("OnEvent", HideGryphons)

-- reference :http://wowwiki.wikia.com/wiki/Creating_simple_pop-up_dialog_boxes
StaticPopupDialogs["BFAUI_WELCOME"] = {
    text = "Welcome to Battle for Azeroth UI",
    button1 = "Continue to options",
    OnAccept = function()
        BFAOptionsFrame:Show()
        PlaySound(88) -- GAMEDIALOGOPEN
    end,
    timeout = 0,
    whileDead = true,
    hideOnEscape = true,
    preferredIndex = 3 -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}

StaticPopupDialogs["ReloadUI_Popup"] = {
    text = "Reload your UI to apply changes?",
    button1 = "Reload",
    button2 = "Later",
    OnAccept = function()
        ReloadUI()
    end,
    timeout = 0,
    whileDead = true,
    hideOnEscape = true,
    preferredIndex = 3
}

local function SetPixelPerfect(self)
    if BFAUI_SavedVars.Options.PixelPerfect == true then
        if not InCombatLockdown() then
            local scale = min(2, max(0.20, 768 / select(2, GetPhysicalScreenSize())))
            scale = tonumber(string.sub(scale, 0, 5)) -- Fix 8.1/Classic scale bug

            if scale < 0.64 then
                UIParent:SetScale(scale)
            else
                self:UnregisterEvent("UI_SCALE_CHANGED")
                SetCVar("uiScale", scale)
            end
        else
            self:RegisterEvent("PLAYER_REGEN_ENABLED")
        end

        if event == "PLAYER_REGEN_ENABLED" then
            self:UnregisterEvent("PLAYER_REGEN_ENABLED")
        end
    end
end

local f = CreateFrame("Frame")
f:RegisterEvent("VARIABLES_LOADED")
f:RegisterEvent("UI_SCALE_CHANGED")
f:SetScript("OnEvent", SetPixelPerfect)

------------------------==≡≡[ DELETE AND DISABLE FRAMES ]≡≡==------------------------

local function noFunc()
    return
end

-- efficiant way to remove frames (does not work on textures)
local function Kill(frame)
    if type(frame) == "table" and frame.SetScript then
        frame:UnregisterAllEvents()
        frame:SetScript("OnEvent", nil)
        frame:SetScript("OnUpdate", nil)
        frame:SetScript("OnHide", nil)
        frame:Hide()
        frame.SetScript = noFunc
        frame.RegisterEvent = noFunc
        frame.RegisterAllEvents = noFunc
        frame.Show = noFunc
    end
end

Kill(ReputationWatchBar)
Kill(HonorWatchBar)
Kill(MainMenuBarMaxLevelBar)

-- disable "Show as Experience Bar" checkbox
ReputationDetailMainScreenCheckBox:Disable()
ReputationDetailMainScreenCheckBoxText:SetTextColor(0.5, 0.5, 0.5)

----------------------------------==≡≡[ XP BAR ]≡≡==----------------------------------

for i = 0, 3 do -- for loop, hides MainMenuXPBarTexture (0-3)
    if _G["MainMenuXPBarTexture" .. i] then
        _G["MainMenuXPBarTexture" .. i]:Hide()
    end
end

MainMenuExpBar:SetFrameStrata("MEDIUM")
ExhaustionTick:SetFrameStrata("HIGH")

MainMenuBarExpText:ClearAllPoints()
MainMenuBarExpText:SetPoint("CENTER", MainMenuExpBar, 0, 0)
MainMenuBarOverlayFrame:SetFrameStrata("HIGH") -- changes xp bar text strata

---------------==≡≡[ MICRO MENU MOVEMENT, POSITIONING AND SIZING ]≡≡==---------------
local MICRO_BUTTONS = MICRO_BUTTONS
if not MICRO_BUTTONS then
    MICRO_BUTTONS = {
        "CharacterMicroButton",
        "SpellbookMicroButton",
        "TalentMicroButton",
        "AchievementMicroButton",
        "QuestLogMicroButton",
        "SocialsMicroButton",
        "PVPMicroButton",
        "LFDMicroButton",
        "MainMenuMicroButton",
        "HelpMicroButton"
    }
end

local function MoveMicroButtonsToBottomRight()
    -- Artwork
    if _G.Dominos or _G.Bartender4 then
      MicroMenuArt:Hide()
      return
    end

    MicroMenuArt:Show()
    MicroMenuArt:SetFrameStrata("BACKGROUND")

    -- MicroMenu Buttons
    local num = #MICRO_BUTTONS
    for i = 1, num do
        local button, nextButton = _G[MICRO_BUTTONS[i]], _G[MICRO_BUTTONS[i - 1]]

        button:ClearAllPoints()
        button:SetSize(28, 58)

        if i == 1 then
            button:SetPoint("BOTTOMRIGHT", MicroMenuArt, "BOTTOMRIGHT", -256, 4)
        else
            button:SetPoint("LEFT", nextButton, "RIGHT", 0, 0)
        end
    end

    -- Bags
    MainMenuBarBackpackButton:SetScale(1)
    for i = 0, 3 do
        local bagFrame, previousBag = _G["CharacterBag" .. i .. "Slot"], _G["CharacterBag" .. i - 1 .. "Slot"]

        bagFrame:SetScale(0.9)
        bagFrame:ClearAllPoints()

        if i == 0 then
            bagFrame:SetPoint("BOTTOMRIGHT", MainMenuBarBackpackButton, "BOTTOMLEFT", -8, 2)
        else
            bagFrame:SetPoint("BOTTOMRIGHT", previousBag, "BOTTOMLEFT", -6, 0)
        end
    end
end

if not MoveMicroButtons then
    MoveMicroButtons = function(anchor, anchorTo, relAnchor, x, y, isStacked)
        CharacterMicroButton:ClearAllPoints()
        CharacterMicroButton:SetPoint(anchor, anchorTo, relAnchor, x, y)
        LFDMicroButton:ClearAllPoints()
        if (isStacked) then
            LFDMicroButton:SetPoint("TOPLEFT", CharacterMicroButton, "BOTTOMLEFT", 0, 24)
        else
            LFDMicroButton:SetPoint("BOTTOMLEFT", GuildMicroButton, "BOTTOMRIGHT", -3, 0)
        end
        UpdateMicroButtons()
    end
end

local function MoveMicroButtons_Hook(...)
    MoveMicroButtonsToBottomRight()
end
hooksecurefunc("MoveMicroButtons", MoveMicroButtons_Hook)
hooksecurefunc("UpdateMicroButtons", MoveMicroButtons_Hook)
hooksecurefunc("MainMenuBarVehicleLeaveButton_Update", MoveMicroButtons_Hook)

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:SetScript("OnEvent", MoveMicroButtonsToBottomRight)

----------------==≡≡[ ACTIONBARS/BUTTONS POSITIONING AND SCALING ]≡≡==----------------

-- Only needs to be run once:
local function Initial_ActionBarPositioning()
    if not InCombatLockdown() then
        -- reposition bottom left actionbuttons
        MultiBarBottomLeftButton1:SetPoint("BOTTOMLEFT", MultiBarBottomLeft, 0, -6)

        -- reposition bottom right actionbar
        MultiBarBottomRight:SetPoint("LEFT", MultiBarBottomLeft, "RIGHT", 43, -6)

        -- reposition second half of top right bar, underneath
        MultiBarBottomRightButton7:SetPoint("LEFT", MultiBarBottomRight, 0, -48)

        -- reposition bags
        MainMenuBarBackpackButton:SetPoint("BOTTOMRIGHT", UIParent, -6, 47)

        -- reposition pet actionbuttons
        SlidingActionBarTexture0:SetPoint("TOPLEFT", PetActionBarFrame, 1, -5) -- pet bar texture (displayed when bottom left bar is hidden)
        PetActionButton1:ClearAllPoints()
        PetActionButton1:SetPoint("TOP", PetActionBarFrame, "LEFT", 51, 4)

        -- stance buttons
        ShapeshiftBarLeft:SetPoint("BOTTOMLEFT", ShapeshiftBarFrame, 0, -5) -- stance bar texture for when Bottom Left Bar is hidden
        ShapeshiftButton1:ClearAllPoints()
    end
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_LOGIN")
f:SetScript("OnEvent", Initial_ActionBarPositioning)

local function ActivateLongBar(xp)
    ActionBarArt:Show()
    ActionBarArtSmall:Hide()

    MainMenuBarLeftEndCap:ClearAllPoints()
    MainMenuBarLeftEndCap:SetPoint("LEFT", ActionBarArt, "LEFT", 12, 0)
    MainMenuBarRightEndCap:ClearAllPoints()
    MainMenuBarRightEndCap:SetPoint("RIGHT", ActionBarArt, "RIGHT", -12, 0)

    if not InCombatLockdown() then
        -- arrows and page number
        ActionBarUpButton:SetPoint("CENTER", MainMenuBarArtFrame, "TOPLEFT", 521, -23)
        ActionBarDownButton:SetPoint("CENTER", MainMenuBarArtFrame, "TOPLEFT", 521, -42)
        MainMenuBarPageNumber:SetPoint("CENTER", MainMenuBarArtFrame, 28, -5)

        -- exp bar sizing and positioning
        MainMenuExpBar:SetSize(798, 10)
        MainMenuExpBar:ClearAllPoints()
        MainMenuExpBar:SetPoint("BOTTOM", UIParent, 0, 0)

        -- reposition ALL actionbars (right bars not affected)
        MainMenuBar:SetPoint("BOTTOM", UIParent, 110, (xp == 0 and 2 or 11))

        -- xp bar background (the one I made)
        XPBarBackground:SetSize(798, 10)
        XPBarBackground:SetPoint("BOTTOM", MainMenuBar, -111, -10)
    end
end

local function ActivateShortBar(xp)
    ActionBarArt:Hide()
    ActionBarArtSmall:Show()

    if not BFAUI_SavedVars.Options.HideGryphons or (MainMenuBarLeftEndCap:IsShown() or MainMenuBarRightEndCap:IsShown()) then
        MainMenuBarLeftEndCap:ClearAllPoints()
        MainMenuBarLeftEndCap:SetPoint("LEFT", ActionBarArt, "LEFT", 12, 0)
        MainMenuBarRightEndCap:ClearAllPoints()
        MainMenuBarRightEndCap:SetPoint("RIGHT", ActionBarArt, "RIGHT", -264, 0)
    else
        MainMenuBarLeftEndCap:Hide()
        MainMenuBarRightEndCap:Hide()
    end

    if not InCombatLockdown() then
        -- arrows and page number
        ActionBarUpButton:SetPoint("CENTER", MainMenuBarArtFrame, "TOPLEFT", 521, -23)
        ActionBarDownButton:SetPoint("CENTER", MainMenuBarArtFrame, "TOPLEFT", 521, -42)
        MainMenuBarPageNumber:SetPoint("CENTER", MainMenuBarArtFrame, 29, -5)

        -- exp bar sizing and positioning
        MainMenuExpBar:SetSize(542, 10)
        MainMenuExpBar:ClearAllPoints()
        MainMenuExpBar:SetPoint("BOTTOM", UIParent, 0, 0)

        -- reposition ALL actionbars (right bars not affected)
        MainMenuBar:SetPoint("BOTTOM", UIParent, 237, (xp == 0 and 2 or 11))

        -- xp bar background (the one I made)
        XPBarBackground:SetSize(542, 10)
        XPBarBackground:SetPoint("BOTTOM", MainMenuBar, -237, -10)
    end
end

local function MainMenuTrackingBar_Configure(frame, isOnTop)
    local statusBar = ReputationWatchStatusBar
    statusBar:SetFrameLevel(MainMenuBarArtFrame:GetFrameLevel() - 1)
    if not frame.Text then
        frame.Text = frame:CreateFontString(frame, "OVERLAY", "GameTooltipText")
    end

    if (isOnTop) then
        statusBar:SetHeight(8)
        frame:ClearAllPoints()
        frame:SetPoint("BOTTOM", MainMenuBar, "TOP", 0, -3)
        frame.Text:SetPoint("CENTER", frame, "CENTER", 0, 3)
    else
        statusBar:SetHeight(13)
        frame:ClearAllPoints()
        frame:SetPoint("TOP", MainMenuBar, "TOP", 0, 0)
        frame.Text:SetPoint("CENTER", frame, "CENTER", 0, 1)
    end
end

local function ExpBar_Update()
    local currXP = UnitXP("player")
    local nextXP = UnitXPMax("player")
    local min, max = math.min(0, currXP), nextXP
    MainMenuExpBar:SetMinMaxValues(min, max)
    MainMenuExpBar:SetValue(currXP)
end

local CONTAINER_OFFSET_Y = 70
local CONTAINER_OFFSET_X = -4
local MINIMUM_CONTAINER_OFFSET_X = 10

local function UpdateContainerFrameAnchors()
    local containerFrameOffsetX = math.max(CONTAINER_OFFSET_X, MINIMUM_CONTAINER_OFFSET_X)
    local frame, xOffset, yOffset, screenHeight, freeScreenHeight, leftMostPoint, column
    local screenWidth = GetScreenWidth()
    local containerScale = 1
    local leftLimit = 0
    if (BankFrame:IsShown()) then
        leftLimit = BankFrame:GetRight() - 25
    end

    while (containerScale > CONTAINER_SCALE) do
        screenHeight = GetScreenHeight() / containerScale
        -- Adjust the start anchor for bags depending on the multibars
        xOffset = containerFrameOffsetX / containerScale
        yOffset = CONTAINER_OFFSET_Y / containerScale
        -- freeScreenHeight determines when to start a new column of bags
        freeScreenHeight = screenHeight - yOffset
        leftMostPoint = screenWidth - xOffset
        column = 1
        local frameHeight
        for index, frameName in ipairs(ContainerFrame1.bags) do
            frameHeight = _G[frameName]:GetHeight()
            if (freeScreenHeight < frameHeight) then
                -- Start a new column
                column = column + 1
                leftMostPoint = screenWidth - (column * CONTAINER_WIDTH * containerScale) - xOffset
                freeScreenHeight = screenHeight - yOffset
            end
            freeScreenHeight = freeScreenHeight - frameHeight - VISIBLE_CONTAINER_SPACING
        end
        if (leftMostPoint < leftLimit) then
            containerScale = containerScale - 0.01
        else
            break
        end
    end

    if (containerScale < CONTAINER_SCALE) then
        containerScale = CONTAINER_SCALE
    end

    screenHeight = GetScreenHeight() / containerScale
    -- Adjust the start anchor for bags depending on the multibars
    xOffset = containerFrameOffsetX / containerScale
    yOffset = CONTAINER_OFFSET_Y / containerScale
    -- freeScreenHeight determines when to start a new column of bags
    freeScreenHeight = screenHeight - yOffset
    column = 0
    for index, frameName in ipairs(ContainerFrame1.bags) do
        frame = _G[frameName]
        frame:SetScale(containerScale)
        if (index == 1) then
            -- First bag
            frame:SetPoint("BOTTOMRIGHT", frame:GetParent(), "BOTTOMRIGHT", -xOffset, yOffset)
        elseif (freeScreenHeight < frame:GetHeight()) then
            -- Start a new column
            column = column + 1
            freeScreenHeight = screenHeight - yOffset
            frame:SetPoint(
                "BOTTOMRIGHT",
                frame:GetParent(),
                "BOTTOMRIGHT",
                -(column * CONTAINER_WIDTH) - xOffset,
                yOffset
            )
        else
            -- Anchor to the previous bag
            frame:SetPoint("BOTTOMRIGHT", ContainerFrame1.bags[index - 1], "TOPRIGHT", 0, CONTAINER_SPACING)
        end
        freeScreenHeight = freeScreenHeight - frame:GetHeight() - VISIBLE_CONTAINER_SPACING
    end
end

local UpdateExperienceBars = MainMenuBar_UpdateExperienceBars
if not UpdateExperienceBars then
    UpdateExperienceBars = function(newLevel)
        local name, reaction, min, max, value = GetWatchedFactionInfo()
        local visibilityChanged = nil
        newLevel = newLevel or UnitLevel("player")
        local showXP = newLevel < MAX_PLAYER_LEVEL and not IsXPUserDisabled()
        local showRep = name
        local numBarsShowing = 0

        --******************* EXPERIENCE **************************************
        if showXP ~= MainMenuExpBar:IsShown() then
            visibilityChanged = true
        end
        if showXP then
            MainMenuExpBar:Show()
            MainMenuExpBar.pauseUpdates = nil
            numBarsShowing = numBarsShowing + 1
        else
            MainMenuExpBar:Hide()
            MainMenuExpBar.pauseUpdates = true
            ExhaustionTick:Hide()
        end

        --******************* REPUTATION **************************************
        if showRep and numBarsShowing < 2 then
            local colorIndex = reaction
            local level = reaction

            -- See if it was already shown or not
            if not ReputationWatchBar:IsShown() then
                visibilityChanged = true
            end

            -- Normalize values
            max = max - min
            value = value - min
            min = 0

            local statusBar = ReputationWatchStatusBar
            statusBar:SetMinMaxValues(min, max)
            statusBar:SetValue(value)

            if not ReputationWatchBar.Text then
                ReputationWatchBar.Text =
                    ReputationWatchBar:CreateFontString(ReputationWatchBar, "OVERLAY", "GameTooltipText")
            end
            ReputationWatchBar.Text:SetText(name .. " " .. value .. " / " .. max)

            local color = FACTION_BAR_COLORS[colorIndex]
            statusBar:SetStatusBarColor(color.r, color.g, color.b)
            ReputationWatchBar:Show()
            MainMenuTrackingBar_Configure(ReputationWatchBar, numBarsShowing > 0)
            numBarsShowing = numBarsShowing + 1
        else
            if ReputationWatchBar:IsShown() then
                visibilityChanged = true
            end
            ReputationWatchBar:Hide()
        end
        if numBarsShowing > 0 then
            MainMenuBarMaxLevelBar:Hide()
        else
            MainMenuBarMaxLevelBar:Show()
        end

        -- update the xp bar
        TextStatusBar_UpdateTextString(MainMenuExpBar)
        ExpBar_Update()

        if visibilityChanged then
            UIParent_ManageFramePositions()
            UpdateContainerFrameAnchors()
        end
    end
end

local function Update_ActionBars()
    if not InCombatLockdown() then
        -- Bottom Left Bar:
        if MultiBarBottomLeft:IsShown() then
            PetActionButton1:SetPoint("TOP", PetActionBarFrame, "LEFT", 51, 4)
            ShapeshiftButton1:SetPoint("LEFT", ShapeshiftBarFrame, 2, -4)
        else
            PetActionButton1:SetPoint("TOP", PetActionBarFrame, "LEFT", 51, 7)
            ShapeshiftButton1:SetPoint("LEFT", ShapeshiftBarFrame, 12, -2)
        end
    end

    -- Bottom Right Bar: (needs to be run in or out of combat, this is for the art when exiting vehicles in combat)
    local xpMax = UnitXPMax("player")
    if MultiBarBottomRight:IsShown() then
        ActivateLongBar(xpMax)
    else
        ActivateShortBar(xpMax)
    end

    -- Fix to show XP bar on load
    UpdateExperienceBars()
end

MultiBarBottomLeft:HookScript("OnShow", Update_ActionBars)
MultiBarBottomLeft:HookScript("OnHide", Update_ActionBars)
MultiBarBottomRight:HookScript("OnShow", Update_ActionBars)
MultiBarBottomRight:HookScript("OnHide", Update_ActionBars)
MultiBarRight:HookScript("OnShow", Update_ActionBars)
MultiBarRight:HookScript("OnHide", Update_ActionBars)
MultiBarLeft:HookScript("OnShow", Update_ActionBars)
MultiBarLeft:HookScript("OnHide", Update_ActionBars)

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_LOGIN") -- Required to check bar visibility on load
f:RegisterEvent("ADDON_LOADED")
f:SetScript("OnEvent", Update_ActionBars)
f:SetScript("OnUpdate", function(self, elapsed)
  if checked then return end
  local xof = select(4, MainMenuBar:GetPoint())
  if xof == 0 then
    MainMenuBar:SetPoint("BOTTOM", UIParent, (MultiBarBottomRight:IsShown() and 110 or 237), (UnitXPMax("player") == 0 and 2 or 11))
  else
    checked = true
  end
end)

local function PlayerEnteredCombat()
    InterfaceOptionsActionBarsPanelTitle:SetText(
        "ActionBars - |cffFF0000You must leave combat to toggle the ActionBars"
    )
    InterfaceOptionsActionBarsPanelBottomLeft:Disable()
    InterfaceOptionsActionBarsPanelBottomRight:Disable()
    InterfaceOptionsActionBarsPanelRight:Disable()
    InterfaceOptionsActionBarsPanelRightTwo:Disable()
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_REGEN_DISABLED")
f:SetScript("OnEvent", PlayerEnteredCombat)

local function PlayerLeftCombat()
    InterfaceOptionsActionBarsPanelTitle:SetText("ActionBars")
    InterfaceOptionsActionBarsPanelBottomLeft:Enable()
    InterfaceOptionsActionBarsPanelBottomRight:Enable()
    InterfaceOptionsActionBarsPanelRight:Enable()
    InterfaceOptionsActionBarsPanelRightTwo:Enable()

    Initial_ActionBarPositioning()
    Update_ActionBars()
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_REGEN_ENABLED")
f:SetScript("OnEvent", PlayerLeftCombat)

--------------------------------==≡≡[ BAG SPACE ]≡≡==--------------------------------

local BagSpaceDisplay = CreateFrame("Frame", "BagSpaceDisplay", MainMenuBarBackpackButton)

BagSpaceDisplay:ClearAllPoints()
BagSpaceDisplay:SetPoint("BOTTOM", MainMenuBarBackpackButton, 0, -8)
BagSpaceDisplay:SetSize(MainMenuBarBackpackButton:GetWidth(), MainMenuBarBackpackButton:GetHeight())

BagSpaceDisplay.text = BagSpaceDisplay:CreateFontString(nil, "OVERLAY", "NumberFontNormal")
BagSpaceDisplay.text:SetAllPoints(BagSpaceDisplay)

local function UpdateBagSpace()
    local totalFree, freeSlots, bagFamily = 0
    for i = BACKPACK_CONTAINER, NUM_BAG_SLOTS do
        freeSlots, bagFamily = GetContainerNumFreeSlots(i)
        if bagFamily == 0 then
            totalFree = totalFree + freeSlots
        end
    end

    BagSpaceDisplay.text:SetText(string.format("(%s)", totalFree))
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_LOGIN")
f:RegisterEvent("BAG_UPDATE")
f:SetScript("OnEvent", UpdateBagSpace)

----------------------------==≡≡[ BLIZZARD TEXTURES ]≡≡==----------------------------

for i = 0, 3 do -- for loop, hides MainMenuBarTexture (0-3)
    if _G["MainMenuBarTexture" .. i] then
        _G["MainMenuBarTexture" .. i]:Hide()
    end
end
